/*jshint eqeqeq:false, strict:false*/
/*global jQuery:false, $:false, box:false, _ga:false, FB:false*/
var _gaq;
if(!_gaq) {
    _gaq = [];
}

box.get('ysl').addModule('services', function($, box) {
    var oDoc = this.window.document,
        oInsert = oDoc.getElementsByTagName('script')[0],
        oLoaded = {},
        oCallbacks = {},
        noop = function() {},
        reLoaded = /loaded|complete/;
    
    function isServiceReady(sName) {
        return oLoaded[sName];
    }
    
    function execCallbacks(sName) {
        if(oCallbacks[sName] && isServiceReady(sName)) {
            var aCallbacks = oCallbacks[sName],
                i = -1,
                l = aCallbacks.length;
            while(++i < l) {
                aCallbacks[i]();
            }
        }
    }
    
    function loadScript(sName) {
        var oDatas = box.get('ysl:service-' + sName),
            sId = sName + '-jssdk',
            sGA = oDatas.stats,
            oJS;
        if(!oDoc.getElementById(sId)) {
            oLoaded[sName] = false;
            oCallbacks[sName] = [];
            oJS = oDoc.createElement('script');
            oJS.id = sId;
            oJS.async = true;
            oJS.onreadystatechange = oJS.onload = function() {
                var sState = oJS.readyState;
                if (!sState || reLoaded.test(sState)) {
                    oJS.onreadystatechange = oJS.onload = noop;
                    oLoaded[sName] = true;
                    if(sGA && typeof _ga === 'object' && _ga && _ga[sGA]) {
                        _ga[sGA]();
                    }
                    execCallbacks(sName);
                }
            };
            oJS.src = oDatas.url;
            oInsert.parentNode.insertBefore(oJS, oInsert);
        }
    }
    
    return {
        load: function(sName) {
            loadScript(sName);
        },
        
        loadMultiple: function(aNames) {
            var i = -1,
                l = aNames.length;
            while(++i < l) {
                loadScript(aNames[i]);
            }
        },
        
        isReady: function(sName) {
            return isServiceReady(sName);
        },
        
        ready: function(sName, callback) {
            if(isServiceReady(sName)) {
                callback();
            } else {
                if(!oCallbacks[sName]) {
                    oCallbacks[sName] = [];
                }
                oCallbacks[sName].push(callback);
            }
        }
    };
});

box.get('ysl').addModule('facebook-login', function($, box) {
    var bBusy = false,
        bSync = false,
        oL10nError = box.get('l10n:error'),
        bRedirect, sUrl, sErrorId;

    function onGenericError(sMsg) {
        box.publish({ type: 'error', label: 'ysl:facebook-login' });
        $(sErrorId).html('<p>' + sMsg + '</p>');
    }

    function onNurunWsSuccess(oResponse) {
        var oData = oResponse.data;
        if(oData.url) {
            box.publish({ type: 'success', label: 'ysl:facebook-login' });
            if(bRedirect === true) {
                box.getWin().location.href = oData.url;
            }
        } else {
            onGenericError(oData.message || oL10nError.fbLogin);
        }
    }

    function onNurunWsError() {
        onGenericError(oL10nError.fbLogin);
    }

    function onUserData(oResponse) {
        oResponse.sync = bSync;
        $.ajax({
            url: sUrl,
            data: oResponse,
            dataType: 'json',
            type: 'POST',
            success: onNurunWsSuccess,
            error: onNurunWsError
        });
    }
    
    function onLogin(oResponse) {
        if(oResponse.authResponse) {
            FB.api('/me', onUserData);
        } else {
            onGenericError(oL10nError.fbLogin);
        }
    }

    return {
        login: function(oData) {
            if(!bBusy && typeof FB === 'object' && !!FB && oData.url && oData.errorId) {
                sUrl = oData.url;
                sErrorId = oData.errorId;
                bRedirect = oData.allowRedirect !== false;
                bSync = !!oData.sync;
                FB.login(onLogin, { scope: oData.permissions || 'email' });
            }
        }
    };
});

box.getJDoc().ready(function() {
    var oServices = box.get('ysl:services'),
        oFBActions = box.get('ysl:service-facebook').actions,
        sTag = box.getDoc().body.getAttribute('data-ga'),
        sTagWR = box.getDoc().body.getAttribute('data-wr'),
        sTagWRLink = 'http://yvessaintlaurentysl.solution.weborama.fr/fcgi-bin/comptage_wreport.fcgi?',
        sFBToken,
        rTagWR = /;/gi;

    _gaq.push([ '_setAccount' , box.get('ysl:service-ga').id ]);
    if(sTag) {
        _gaq.push([ '_trackPageview', sTag ]);
    }

    box.subscribe(
        {
            name: 'click>outgoing',
            handler: function(oEvt) {
                var oData = oEvt.data;
                oData.originalEvent.preventDefault();
                _gaq.push([ '_trackEvent', 'Outbound', oData.url ]);
                box.getWin().open(oEvt.data.url);
            }
        }
    );

    oServices.loadMultiple([ 'ga', 'facebook', 'pinit', 'twitter', 'gplus' ]);

    oServices.ready('facebook', function() {
        if(box.getDoc().getElementById('fb-root')) {
            FB.init({
                appId: box.get('ysl:service-facebook').id,
                status: true,
                cookie: true,
                xfbml: true
            });
        }
    });
    
    /* Weborama */
    if(sTagWR){
        sTagWR = sTagWR.replace(rTagWR,'&');
        var oTagWRimg = new Image();
        oTagWRimg.src = sTagWRLink + sTagWR;
    }
    
});

/*<!-- Start Visual Website Optimizer Asynchronous Code -->
var _vwo_code=(function(){
var account_id=5704,
settings_tolerance=1500,
library_tolerance=3000,
use_existing_jquery=false,
// DO NOT EDIT BELOW THIS LINE
f=false,d=document;return{use_existing_jquery:function(){return use_existing_jquery;},library_tolerance:function(){return library_tolerance;},finish:function(){if(!f){f=true;var a=d.getElementById('_vis_opt_path_hides');if(a)a.parentNode.removeChild(a);}},finished:function(){return f;},load:function(a){var b=d.createElement('script');b.src=a;b.type='text/javascript';b.innerText;b.onerror=function(){_vwo_code.finish();};d.getElementsByTagName('head')[0].appendChild(b);},init:function(){settings_timer=setTimeout('_vwo_code.finish()',settings_tolerance);this.load('//dev.visualwebsiteoptimizer.com/j.php?a='+account_id+'&u='+encodeURIComponent(d.URL)+'&r='+Math.random());var a=d.createElement('style'),b='body{opacity:0 !important;filter:alpha(opacity=0) !important;background:none !important;}',h=d.getElementsByTagName('head')[0];a.setAttribute('id','_vis_opt_path_hides');a.setAttribute('type','text/css');if(a.styleSheet)a.styleSheet.cssText=b;else a.appendChild(d.createTextNode(b));h.appendChild(a);return settings_timer;}};}());_vwo_settings_timer=_vwo_code.init();*/
/*<!-- End Visual Website Optimizer Asynchronous Code -->*/
