/*jshint eqeqeq:false, strict:false*/
/*global $:false, jQuery:false, box:false*/
box.store('ysl').addModule('main-nav', function($, box) {
    var $mainNav,
        timerMainNav,
        reExtractType = /\bnav-(moodboards|products)\b/,
        reExtractCat = /(?:favorites|library|creations)\b/i,        
        reExtractVisual = /<span data-box="?name=([^;]*);url=([^";]+)"?><\/span>/i,
        reDecodeName = /alt="([^"]+)"/,
        oL10nGeneric = box.get('l10n:generic'),
        oL10nError = box.get('l10n:error'),
        oL10nPage = box.get('l10n:pagination'),
        oAPI,
        oMask,
        oXHRItems,
        oXHRLogin;
    
    // configure paginations
    box.get('ysl').modifyConfig('paginate', {
        htmlNavFirst: '<li><a href="#" class="page-first"{$data} title="' + oL10nPage.first + '">&lt;&lt;</a></li>',
        htmlNavLast: '<li><a href="#" class="page-last"{$data} title="' + oL10nPage.last + '">&gt;&gt;</a></li>',
        htmlNavPrev: '<li><a href="#" class="page-previous"{$data} title="' + oL10nPage.prev + '">&lt;</a></li>',
        htmlNavNext: '<li><a href="#" class="page-next"{$data} title="' + oL10nPage.next + '">&gt;</a></li>'
    });
    
    function createMask() {
        oMask = box.get('ui').create('element.header-mask', {
            rootHtml: '<div id="header-mask"></div>'
        });
    }

    function createTooltips() {
        box.get('ui').create('tooltip.nav', {
            rootHtml: '<div class="nav-tooltip"></div>',
            srcElm: $mainNav.find('> ul > li > a'),
            position: 'bc',
            delay: 500,
            offsetBottom: 1
        });
    }

    function getTooltipContent(oEvt) {
        var $src = oEvt.source.datas.srcElm;
        if(!$src.hasClass('nav-no-tooltip') && !$src.hasClass('on')) {
            oEvt.source.setContent($src.html());
        }
    }

    function createTabs() {
        var oCfgTabs = {
            clsTabList: 'nav-tabs',
            clsTabActive: 'nav-on',
            clsTabPanel: 'nav-tab-panel',
            clsTabActivePanel: 'nav-tab-panel-on'
        };
        oCfgTabs.tabListElm = $mainNav.find('.nav-products .nav-tabs');
        box.get('ui').create('tabs.nav-products', oCfgTabs); 
        oCfgTabs.tabListElm = $mainNav.find('.nav-moodboards .nav-tabs');
        box.get('ui').create('tabs.nav-moodboards', oCfgTabs);
    }

    function createMoodboardsPagination() {
        var oCfgPagination = {
            itemSelector: 'div.nav-catalog-section',
            itemsPerPage: 3,
            firstLastBtn: true,
            prevNextBtn: true
        };
        oCfgPagination.rootElm = '#nav-moodboards-by-ysl-content';
        box.get('ysl').create('paginate.moodboard-by-ysl', oCfgPagination);
        if(box.getDoc().getElementById('nav-moodboards-by-them-content')) {
            oCfgPagination.rootElm = '#nav-moodboards-by-them-content';
            box.get('ysl').create('paginate.moodboard-by-them', oCfgPagination);
        }
        if(box.getDoc().getElementById('nav-moodboards-by-you-content')) {
            oCfgPagination.rootElm = '#nav-moodboards-by-you-content';
            box.get('ysl').create('paginate.moodboard-by-you', oCfgPagination);
        }
    }
    
    function placeBgCat(sCurrentSubCat) {
        var $navYSL = $('#main-nav .nav-ysl'),
            wPage = $(window).width(),
            wUl = $navYSL.find('.nav-expand > ul').width(),
            posUl = (wPage - wUl)/2,
            wLiMoodBoards = $navYSL.find('.nav-moodboards').outerWidth(true),
            hLiMoodBoards = $navYSL.find('.nav-moodboards').outerHeight(true),
            hLiProducts = $navYSL.find('.nav-products').outerHeight(true),
            nProductsBgDecalage = 130,
            posBgLeft = posUl + wLiMoodBoards,
            wProductsBg = wPage - posBgLeft,
            nMoodBoardsBgDecalage = 20,
            posMoodBoardsBg =  posUl - nMoodBoardsBgDecalage,
            wMoodBoardsBg = posUl + wLiMoodBoards;
            
        if($navYSL.find('.nav-expand-bg').length === 0) {
            $navYSL.find('.nav-expand').append('<div class="nav-expand-bg"><span></span></div>');
        }
        
        if(sCurrentSubCat == 'moodboards') {
            $navYSL.find('.nav-expand-bg').css({
                left: '0',
                width: wMoodBoardsBg + 'px',
                height: hLiMoodBoards + 'px',
                backgroundImage: 'url(/img/common/nav-moodboards.jpg)',
                backgroundPosition: posMoodBoardsBg + 'px -1px'
            });
        } else {
            $navYSL.find('.nav-expand-bg').css({
                left: posBgLeft + 'px',
                width: wProductsBg + 'px',
                height: hLiProducts + 'px',
                backgroundImage: 'url(/img/common/nav-products.jpg)',
                backgroundPosition: nProductsBgDecalage + 'px -1px'
            });
        }
    }
    
    function extractCategory(sClass) {
        var aMatch = sClass.match(reExtractType);
        return aMatch ? aMatch[1] : null;
    }
    
    function addLoader($currentSubCatLink) {
        var oLoader = box.get('ui:element.nav-loader');
        if(oLoader) {
            box.get('ui:element.nav-loader').remove();
        } else {
            oLoader = box.get('ui').create('element.nav-loader', {
                rootHtml: '<div class="nav-loader"><img src="/img/common/nav-load-ajax.gif" alt=""></div>'
            });
        }

        if($currentSubCatLink.is(":visible")) {
            oLoader
                .setVisibility(false)
                .setStyles({ opacity: 1 })
                .insert('beforeEnd', document.body)
                .setPosition({ self: 'cl', to: 'cr' }, $currentSubCatLink)
                .setVisibility(true);
        }
    }

    function removeLoader() {
        var oLoader = box.get('ui:element.nav-loader');
        if(oLoader.animating) {
            oLoader.remove();
        } else {
            oLoader.animate({ opacity: 0 }, 300, 'close');
        }
    }
    
    function closeByClickingMask() {
        oAPI.closeCategory(oMask.currentCat);
    }

    function attachLoginFocusBlur() {
        $('#nav-connect-email').unbind('focus blur').focus(function() {
            if(this.value.toLowerCase() == oL10nGeneric.mail.toLowerCase()) {
                this.value = '';
            }
        }).blur(function() {
            if(/^\s*$/.test(this.value)) {
                this.value = oL10nGeneric.mail;
            }
        });
        $('#nav-connect-pwd').unbind('focus blur').focus(function() {
            if(this.value.toLowerCase() == oL10nGeneric.pwd.toLowerCase()) {
                this.value = '';
            }
        }).blur(function() {
            if(/^\s*$/.test(this.value)) {
                this.value = oL10nGeneric.pwd;
            }
        });
    }

    function createNavConnectForm() {
        if(!document.getElementById('nav-connect')) {
            return;
        }

        box.get('ui').destroy('form.nav-connect');
        attachLoginFocusBlur();
        box.get('ui').create('form.nav-connect', {
            rootElm: '#nav-connect'
        }).addReplacement().mustValidate(function(oForm) {
            oForm.field('nav-connect-email').mustValidate(function(oField) {
                if(oField.isEmpty() || oField.getValue().toLowerCase() == oL10nGeneric.mail.toLowerCase()) {
                    return oL10nError.required;
                } else if(!oField.isMatching('email')) {
                    return oL10nError.invalid;
                }
            });

            oForm.field('nav-connect-pwd').mustValidate(function(oField) {
                if(oField.isEmpty() || oField.getValue().toLowerCase() == oL10nGeneric.pwd.toLowerCase()) {
                    return oL10nError.required;
                }
            });

            return oL10nError.login;
        });
    }

    function manageOpenCloseCat(oEvt) {
        var oData = oEvt.data;
        oData.originalEvent.preventDefault();
        if(!$(oData.element).hasClass('on')) {
            oAPI.openCategory(oData.name);
        } else {
            oAPI.closeCategory(oData.name);
        }
    }

    function manageOpenCloseSubCat(oEvt) {
        var oData = oEvt.data;
        oData.originalEvent.preventDefault();
        if(oData.action == 'close') {
            oAPI.closeYslSubCat();
        } else if(!$(oData.element).parent().hasClass('nav-' + oData.name + '-on')) {
            oAPI.openYslSubCat(oData.name);
        }
    }

    function manageItems(oEvt) {
        var oData = oEvt.data,
            $elm = $(oData.element),
            $parent = $elm.parent();
        oData.originalEvent.preventDefault();
        if(!$parent.hasClass('on') && (!oXHRItems || !oXHRItems.requesting)) {
            $mainNav.find('#nav-my-items li').removeClass('on');
            $parent.addClass('on');
            oAPI.loadMyItems($elm.attr('href'));
        }
    }

    function handleXhrResponse(oEvt) {
        oEvt.preventDefault();
        var uResponse = oEvt.data.response;
        if(box.isObject(uResponse)) {
            if(uResponse.data.html) {
                oEvt.source.done('success', uResponse.data.html);
                return;
            } else if(uResponse.data.message) {
                oEvt.source.done('errormessage', uResponse.data.message);
                return;
            }
        }
        oEvt.source.done('errormessage', oL10nError.loading);
    }

    function handleItemsError(oEvt) {
        $mainNav.find('.nav-my-items-listing').html('<p>' + oEvt.data.response + '</p>');
        removeLoader();
        if(oEvt.source.response.action == 'URL_REDIRECT') {
            box.getWin().location.href = oEvt.source.response.data.url;
        }
    }

    function handleItemsSuccess(oEvt) {
        $mainNav.find('.nav-my-items-listing').html(oEvt.data.response);
        box.get('ysl').create('paginate.my-items', {
            rootElm: $mainNav.find('ul.nav-my-items-visu'),
            itemsPerPage: 4,
            firstLastBtn: true,
            prevNextBtn: true
        });
        removeLoader();
    }

    function handleLoginSubmit(oEvt) {
        if(oEvt.data.valid === true && oEvt.data.domEvt) {
            oEvt.data.domEvt.preventDefault();
            oXHRLogin = box.get('util:xhr.ysllogin') || box.get('util').create('xhr.ysllogin');
            if(!oXHRLogin.requesting) {
                addLoader($mainNav.find('#nav-connect legend span'));
                if(oXHRItems) {
                    oXHRItems.abort();
                }
                oXHRLogin.request({
                    url: oEvt.source.dom.attr('action'),
                    params: box.get('ui:form.nav-connect').dom.serialize(),
                    method: 'POST'
                });
            }
        }
    }

    function handleLoginError(oEvt) {
        $mainNav.find('#nav-connect-error').html('<p>' + oEvt.data.response + '</p>');
        box.get('ui:form.nav-connect').enable();
        removeLoader();
    }

    function handleLoginSuccess(oEvt) {
        box.get('ui').destroy('form.nav-connect');
        $('#nav-connect-email, #nav-connect-pwd').unbind('focus blur');
        $mainNav.find('.nav-yslbyme .nav-expand').html(oEvt.data.response);
        removeLoader();
        oAPI.loadMyItems();
    }

    function decodeVisualName(sFull, sName) {
        return 'alt="' + decodeURIComponent(sName) + '"';
    }

    function addPageItemVisual(sHtml) {
        return sHtml.replace(reExtractVisual, '<img alt="$1" src="$2">').replace(reDecodeName, decodeVisualName);
    }

    function modifyPageItemsHtml(oEvt) {
        var aDatas = oEvt.source.datas,
            i = aDatas.length;
        while(i--) {
            aDatas[i] = addPageItemVisual(aDatas[i]);
        }
    }

    function modifyOnePageHtml(oEvt) {
        oEvt.source.rootElm.find('li').each(function(i, oElm) {
            oElm.innerHTML = addPageItemVisual(oElm.innerHTML);
        });
    }

    function onSubCatHover() {
        var $this = $(this),
            sCurrentSubCat = extractCategory($this.attr('class'));
        if(!$this.hasClass('nav-' + sCurrentSubCat + '-on') && !$this.hasClass('nav-' + sCurrentSubCat + '-off')) {
            // timerMainNav = box.getWin().setTimeout(function() {
                $this.parents('.nav-expand').addClass('nav-expand-' + sCurrentSubCat);
                placeBgCat(sCurrentSubCat);
            // }, 200);
        }
    }

    function onSubCatOut() {
        var $this = $(this),
            sCurrentSubCat = extractCategory($this.attr('class'));
        if(!$this.hasClass('nav-' + sCurrentSubCat + '-on') && !$this.hasClass('nav-' + sCurrentSubCat + '-off')) {
            // box.getWin().clearTimeout(timerMainNav);
            $mainNav.find('.nav-ysl .nav-expand-bg').remove();
            $(this).parents('.nav-expand').removeClass('nav-expand-' + sCurrentSubCat);
        }
    }
    function clearSearchField(){
        if($(this).parent().find('label').text() == $(this).val()){
            $(this).val('');
        }        
    }
    
    function openShare() {
        var sQuery = box.getWin().location.search;
        if(sQuery.indexOf('open=share') > -1) {
            oAPI.openCategory('share');
        }
    }
    
    function init() {
        $mainNav = $('#main-nav');
        $mainNav.find('.nav-ysl .nav-moodboards, .nav-ysl .nav-products,').append('<span class="nav-not-expanded-bg"></span>');
        $mainNav.find('.nav-moodboards, .nav-products').hover(onSubCatHover, onSubCatOut);
        $('#nav-searchterms').focus(clearSearchField);
        
        createMask();
        createTooltips();
        createTabs();
        createMoodboardsPagination();
        createNavConnectForm();
        
        box.get('util:delegate-click').setMaxIter(2).start();

        $('#nav-connect-fb').find('a.fb-btn').click(function(oEvt) {
            oEvt.preventDefault();
            box.get('ysl:facebook-login').login({
                url: this.href,
                errorId: '#nav-connect-error'
            });
        });

        openShare();
        
        box.subscribe(
            // Delegate click
            {
                name: 'click>main-nav-cat',
                handler: manageOpenCloseCat
            }, {
                name: 'click>main-nav-subcat',
                handler: manageOpenCloseSubCat
            }, {
                name: 'click>main-nav-items',
                handler: manageItems
            },

            // Tooltips
            {
                name: 'requestcontent>ui:tooltip.nav',
                handler: getTooltipContent
            }, {
                name: 'insert>ui:tooltip.nav',
                handler: function(oEvt) {
                    oEvt.source.rootElm.css('opacity', '0');
                }
            }, {
                name: 'beforeopen>ui:tooltip.nav',
                handler: function(oEvt) {
                    oEvt.source.animate({ opacity: 1 }, 300);
                }
            }, {
                name: 'beforeclose>ui:tooltip.nav',
                handler: function(oEvt) {
                    oEvt.source.animate({ opacity: 0 }, 300);
                }
            },

            // XHR response treatment
            {
                name: [
                    'response>util:xhr.myysl',
                    'response>util:xhr.ysllogin'
                ],
                handler: handleXhrResponse
            },

            // YSLbyMe
            {
                name: 'errormessage>util:xhr.myysl',
                handler: handleItemsError
            }, {
                name: 'success>util:xhr.myysl',
                handler: handleItemsSuccess
            },

            // Login Form
            {
                name: [
                    'error>ui:field.text.nav-connect-email',
                    'valid>ui:field.text.nav-connect-email',
                    'error>ui:field.text.nav-connect-pwd',
                    'valid>ui:field.text.nav-connect-pwd'
                ],
                handler: function(oEvt) {
                    oEvt.stopPropagation();
                }
            }, {
                name: 'submit>ui:form.nav-connect',
                handler: handleLoginSubmit
            }, {
                name: 'errormessage>util:xhr.ysllogin',
                handler: handleLoginError
            }, {
                name: 'success>util:xhr.ysllogin',
                handler: handleLoginSuccess
            },

            // Loader YSLbyMe
            {
                name: 'close>ui:element.nav-loader',
                handler: function(oEvt) {
                    box.get('ui:element.nav-loader').remove();
                }
            },

            // Pagination YSLbyMe
            {
                name: 'ready>ysl:paginate.my-items',
                handler: modifyPageItemsHtml
            }, {
                name: 'onepage>ysl:paginate.my-items',
                handler: modifyOnePageHtml
            }
        );
    }
    
    oAPI = {
        openCategory: function(sCat) {
            var $cat = $mainNav.find('.nav-' + sCat);
            if(!$cat.length) {
                return;
            }
            var $catOpen = $mainNav.find('> ul > li > a.on'),
                sUA = navigator.userAgent,
                tIsIpad = sUA.match(/iPad/);
            if($catOpen.length > 0) {
               oAPI.closeCategory($catOpen.parent().attr('class').replace('nav-', ''), false);
            } else {
                oMask.insert('beforeEnd', box.getDoc().body).setStyles({ opacity: 0.55 }).cover('document');
                oMask.rootElm.click(closeByClickingMask);
            }
            oMask.currentCat = sCat;
            if(sCat == 'yslbyme') {
                oAPI.loadMyItems();
            }

            if(!tIsIpad) {
                $cat
                    .find('> a')
                        .addClass('on')
                    .end()
                    .find('.nav-expand')
                        .slideDown();
            } else {
                $cat
                    .find('> a')
                        .addClass('on')
                    .end()
                    .find('.nav-expand')
                        .css('display','block');
            }
        },

        closeCategory: function(sCat, bCloseMask) {
            if(sCat == 'ysl') {
                oAPI.closeYslSubCat();
            }
            if(sCat == 'yslbyme') {
                oAPI.closeYslByMeSubCat();
                $mainNav.find('.nav-my-items-listing').html('<p>' + oL10nGeneric.loading + '</p>');
            }
            $('.nav-' + sCat)
                .find('> a')
                    .removeClass('on')
                .end()
                .find('.nav-expand')
                    .css('display','none');
            if(bCloseMask !== false) {
                oMask.rootElm.unbind('click');
                oMask.remove();
            }
        },

        openYslSubCat: function(sCurrentSubCat) {
            $mainNav.find('.nav-' + sCurrentSubCat)
                .addClass('nav-' + sCurrentSubCat + '-on')
                .removeClass('nav-' + sCurrentSubCat + '-off');
            $mainNav.find('.nav-footer').css('display','none');
            
            if(sCurrentSubCat == 'moodboards') {
                $mainNav.find('.nav-expand').removeClass("nav-expand-products").addClass("nav-expand-moodboards");
                $mainNav.find('.nav-products').addClass("nav-products-off").removeClass("nav-products-on");            
                $mainNav.find('.nav-catalog').css('display','none');
                $mainNav.find('.nav-moodboards-collection').css('display','block');
            } else {
                $mainNav.find('.nav-expand').removeClass("nav-expand-moodboards").addClass("nav-expand-products");
                $mainNav.find('.nav-moodboards').addClass("nav-moodboards-off").removeClass("nav-moodboards-on");
                $mainNav.find('.nav-moodboards-collection').css('display','none');
                $mainNav.find('.nav-catalog').css('display','block');
            }
            placeBgCat(sCurrentSubCat);
        },

        closeYslSubCat: function() {
            $mainNav.find('.nav-moodboards-collection,.nav-catalog').css('display','none');
            $mainNav.find('.nav-footer').css('display','block');
            $mainNav.find('.nav-ysl .nav-expand-bg').remove();
            $mainNav.find('.nav-moodboards').removeClass('nav-moodboards-on nav-moodboards-off');
            $mainNav.find('.nav-products').removeClass('nav-products-on nav-products-off');
            $mainNav.find('.nav-expand').removeClass('nav-expand-moodboards nav-expand-products');
        },

        closeYslByMeSubCat: function() {
           $('#nav-my-items ul li').removeClass('on');
        },

        loadMyItems: function(sUrl) {
            if(!sUrl) {
                sUrl = $mainNav.find('.nav-my-items-listing').attr('data-url');
            }
            if(!sUrl) {
                return;
            }
            
            var aCat = sUrl.match(reExtractCat),
                $currentSubCatLink;
            
            if(!oXHRItems) {
                oXHRItems = box.get('util').create('xhr.myysl');
            }
            
            if(!oXHRItems.requesting && aCat) {
                box.get('ysl').destroy('paginate.my-items');
                $mainNav.find('#nav-my-items li').removeClass('on');
                $currentSubCatLink = $mainNav.find('#nav-my-items li a[href*="' + aCat[0] + '"]');
                $currentSubCatLink.parent().addClass('on');
                addLoader($currentSubCatLink);
                oXHRItems.request({ url: sUrl, method: 'POST' });
            }
        }
    };
    
    box.getJDoc().ready(function() {
        if(this.getElementById('main-nav')) {
            init();
        }
    });
    
    return oAPI;
});