/*jshint eqeqeq:false, strict:false*/
/*global jQuery:false, $:false, box:false*/
box.store('ysl').addModule('forms', function($, box) {
    return {
        addFormError: function(oEvt) {
            if(oEvt.source.msg) {
                $('#' + oEvt.source.id + '-error').html('<p>' + oEvt.source.msg + '</p>');
            }
        },
        
        addFieldError: function(oEvt) {
            var sGroup = oEvt.source.dom.getBoxData('group'),
                sId = sGroup || oEvt.source.name,
                $error = $('#' + sId + '-error'),
                $label;
            if($error.length) {               
                $error.html(oEvt.data.message);
            } else {
                $label = sGroup ? oEvt.source.getLegend() : oEvt.source.getLabel();
                $label.append('<em id="' + sId + '-error" class="error">' + oEvt.data.message + '</em>');
            }
            $error = $label = null;
        },
        
        removeFieldError: function(oEvt) {
            $('#' + (oEvt.source.dom.getBoxData('group') || oEvt.source.name) + '-error').remove();
        },
        
        INCOMPLETE_DATE: 0,
        VALID_DATE: 1,
        INVALID_DATE: 2,
        FUTURE_DATE: 3,
        TOO_YOUNG_DATE: 4,
        TOO_OLD_DATE: 5,
        
        checkDate: function(oForm, sBaseId, nMinAge) {
            var sDay = oForm.field(sBaseId + 'birthday').getValue(),
                sMonth = oForm.field(sBaseId + 'month').getValue(),
                sYear = oForm.field(sBaseId + 'year').getValue(),
                nDay = parseInt(sDay, 10),
                nMonth = parseInt(sMonth, 10) -1,
                nYear = parseInt(sYear, 10),
                dBirth = new Date(nYear, nMonth, nDay),
                nBirthTS = +dBirth,
                dNow = new Date(),
                nNowTS = +new Date(dNow.getFullYear(), dNow.getMonth(), dNow.getDate()),
                nMaxAgeTS = +new Date(dNow.getFullYear() - 120, dNow.getMonth(), dNow.getDate()),
                nMinAgeTS = isNaN(nMinAge) ? null : +new Date(dNow.getFullYear() - nMinAge, dNow.getMonth(), dNow.getDate());
            if(!oForm.submitting && (isNaN(nDay) || isNaN(nMonth) || isNaN(nYear))) {
                return this.INCOMPLETE_DATE;
            }
            if(isNaN(nBirthTS)) {
                return this.INVALID_DATE;
            } else if(nBirthTS > nNowTS) {
                return this.FUTURE_DATE;
            } else if(nMinAgeTS && nBirthTS > nMinAgeTS) {
                return this.TOO_YOUNG_DATE;
            } else if(nBirthTS < nMaxAgeTS) {
                return this.TOO_OLD_DATE;
            } else {
                oForm.field(sBaseId + 'birthday').setValue(dBirth.getDate(), false);
                oForm.field(sBaseId + 'month').setValue(dBirth.getMonth() + 1, false);
                oForm.field(sBaseId + 'year').setValue(dBirth.getFullYear(), false);
                return this.VALID_DATE;
            }
        }
    };
});

box.subscribe(
    {
        name: 'submit>ui:form',
        handler: function(oEvt) {
            if(oEvt.data.valid === false) {
                box.get('ysl:forms').addFormError(oEvt);
            }
        }
    }, {
        name: 'error>ui:field',
        handler: function(oEvt) {
            box.get('ysl:forms').addFieldError(oEvt);
        }
    }, {
        name: 'valid>ui:field',
        handler: function(oEvt) {
            box.get('ysl:forms').removeFieldError(oEvt);
        }
    }
);

box.getJDoc().ready(function() {
    $('body').bind('touchend', function(oEvt) {
        var i = -1,
            oTargetElm = oEvt.target;
        while(++i < 3) {
            if(oTargetElm.tagName === 'LABEL') {
                var oInputElm = box.getDoc().getElementById(oTargetElm.htmlFor);
                if(oInputElm && /^(?:checkbox|radio)$/.test(oInputElm.type)) {
                    oEvt.preventDefault();
                    oInputElm.click();
                    oInputElm.focus();
                }
                break;
            } else {
                oTargetElm = oTargetElm.parentNode;
            }
        }
    });
});
