/*global box:false*/
box.store('ysl').addConfig('slideshow', {
    clsRoot: 'slideshow',
    clsDatas: 'slideshow-datas',
    clsContent: 'slideshow-content',
    clsEmpty: 'slideshow-content-empty',
    clsDescription: 'slideshow-description',
    clsLoader: 'slideshow-loader',
    clsPrev: 'slideshow-prev',
    clsNext: 'slideshow-next',
    htmlContent: '<div class="{$clsContent}"></div>',
    htmlDescription: '<div class="{$clsDescription}"></div>',
    htmlLoader: '<div class="{$clsLoader}"></div>',
    htmlPrev: '<a href="#" class="{$clsPrev}"{$data}>&lt;</a>',
    htmlNext: '<a href="#" class="{$clsNext}"{$data}>&gt;</a>',
    emptyHeight: 301
}).addConstructor('slideshow', function($, box) {
    var extractDatas, managePagination, addContent, getBoxData, addPagination,
        startDisplay, endDisplay, changeDescription, animAfterChange, errorImg, changeImg,
        oProto;
    
    extractDatas = function(oCom) {
        return function(i, oElm) {
            oCom.datas[i] = {
                url: oElm.getAttribute('href'),
                html: oElm.innerHTML
            };
        };
    };
    
    managePagination = function(oEvt) {
        var oData = oEvt.data,
            sAction = oData.action;
        oData.originalEvent.preventDefault();
        if(sAction && this[sAction]) {
            this[sAction]();
        }
    };
    
    addContent = function(oCom) {
        var oCfg = oCom.cfg;
        oCom.contentElm = $(oCfg.htmlContent.replace('{$clsContent}', oCfg.clsContent)).prependTo(oCom.rootElm);
        oCom.maxWidth = oCom.contentElm.width();
    };

    getBoxData = function(sName, sAction) {
        return ' data-box="label=' + sName +';action=' + sAction + '"';
    };
    
    addPagination = function(oCom) {
        var oCfg = oCom.cfg,
            sName = oCom.boxGetName();
        oCom.pagination = true;
        oCom.contentElm.append(
            oCfg.htmlPrev.replace('{$clsPrev}', oCfg.clsPrev).replace('{$data}', getBoxData(sName, 'previous')) +
            oCfg.htmlNext.replace('{$clsNext}', oCfg.clsNext).replace('{$data}', getBoxData(sName, 'next'))
        );
        box.subscribe({
            name: 'click@box>' + sName,
            context: oCom,
            handler: managePagination
        });
        box.get('util:delegate-click').start();
    };
    
    startDisplay = function(oCom) {
        return function() {
            oCom.loader
                .setStyles({ opacity: 0 })
                .insert('afterBegin', oCom.contentElm)
                .animate({ opacity: 1 }, 300, 'show');
            oCom.img.single(oCom.datas[oCom.current].url);
        };
    };
    
    endDisplay = function(oCom) {
        return function() {
            if(!oCom.pagination) {
                addPagination(oCom);
            }
            oCom.loader.animate({ opacity: 0 }, 300, 'hide');
        };
    };
    
    changeDescription = function(oCom) {
        var oCfg = oCom.cfg,
            sPage = (oCom.current + 1) + '/' + oCom.datas.length + ' ';
        oCom.description.setContent('<p>' + sPage + oCom.datas[oCom.current].html + '</p>');
        oCom.description.totalHeight = oCom.description.rootElm.children()[0].scrollHeight;
    };
    
    animAfterChange = function(oCom, nImgHeight) {
        var nDescHeight = oCom.description.totalHeight,
            nTotalHeight = nImgHeight + nDescHeight;
        oCom.description.rootElm.animate({ height: nDescHeight }, 500);
        oCom.contentElm.animate({ height: nImgHeight }, {
            duration: 500,
            complete: endDisplay(oCom),
            step: function(nHeight) {
                oCom.boxPublish('changeheight', { height: nHeight, totalHeight: nTotalHeight, propagate: false });
            }
        });
    };
    
    errorImg = function(oCom) {
        oCom.contentElm.find('img').remove();
        changeDescription(oCom);
        oCom.contentElm.addClass(oCom.cfg.clsEmpty);
        animAfterChange(oCom, oCom.cfg.emptyHeight);
    };
    
    changeImg = function(oCom) {
        oCom.contentElm.find('img').remove();
        if(oCom.nextImgDatas.width > oCom.maxWidth) {
            oCom.nextImgDatas.img.width = oCom.maxWidth;
            oCom.nextImgDatas.img.height *= oCom.maxWidth / oCom.nextImgDatas.width;
        }
        changeDescription(oCom);
        oCom.boxPublish('requestheight', { propagate: false });
        oCom.contentElm.append(oCom.nextImgDatas.img);
        animAfterChange(oCom, oCom.nextImgDatas.img.height);
    };
    
    oProto = {
        boxCreate: function(oDatas) {
            var oCfg = this.cfg,
                sId = '.slideshow-' + this.id;
            this.rootElm = $(oDatas.rootElm);
            this.datas = [];
            this.rootElm.find('.' + oCfg.clsDatas + ' a').each(extractDatas(this));
            this.loading = this.pagination = false;
            if(this.datas.length) {
                addContent(this);
                box.subscribe(
                    {
                        name: 'preloadready@box>util:loadimage' + sId,
                        context: this,
                        handler: function(oEvt) {
                            this.nextImgDatas = oEvt.data;
                            if(!this.loader.animating) {
                                changeImg(this);
                            }
                        }
                    }, {
                        name: 'preloaderror@box>util:loadimage' + sId,
                        context: this,
                        handler: function(oEvt) {
                            this.nextImgDatas = 'error';
                            if(!this.loader.animating) {
                                errorImg(this);
                            }
                        }
                    }, {
                        name: 'show@box>ui:element' + sId + '-loader',
                        context: this,
                        handler: function() {
                            if(this.nextImgDatas === 'error') {
                                errorImg(this);
                            } else if(this.nextImgDatas) {
                                changeImg(this);
                            }
                        }
                    }, {
                        name: 'hide@box>ui:element' + sId + '-loader',
                        context: this,
                        handler: function() {
                            this.loader.remove();
                            this.loading = false;
                            this.description.rootElm.animate({ opacity: 1 }, 300);
                        }
                    }
                );
                this.description = box.get('ui').create('element' + sId + '-description');
                this.description
                    .setRoot(oCfg.htmlDescription.replace('{$clsDescription}', oCfg.clsDescription))
                    .setContent('<p>-</p>')
                    .setStyles({ overflow: 'hidden', opacity: 0 })
                    .insert('afterEnd', this.contentElm);
                this.description.rootElm.height(this.description.rootElm.height());
                this.loader = box.get('ui').create('element' + sId + '-loader', {
                    rootHtml: oCfg.htmlLoader.replace('{$clsLoader}', oCfg.clsLoader)
                });
                this.img = box.get('util').create('loadimage' + sId);
                this.load(0);
            }
        },

        boxDestroy: function() {
            var sId = '.slideshow-' + this.id;
            box.unsubscribe(
                'click@box>' + this.boxGetName(),
                'preloadready@box>util:loadimage' + sId,
                'preloaderror@box>util:loadimage' + sId,
                'show@box>ui:element' + sId + '-loader',
                'hide@box>ui:element' + sId + '-loader'
            );
        },
        
        load: function(nIndex) {
            if(!this.loading && nIndex >= 0 && nIndex < this.datas.length) {
                this.loading = true;
                this.current = nIndex;
                this.nextImgDatas = null;
                this.contentElm.removeClass(this.cfg.clsEmpty);
                this.description.rootElm.animate({ opacity: 0 }, 300, startDisplay(this));
            }
        },
        
        previous: function() {
            if(this.datas.length > 1) {
                var nIndex = this.current - 1;
                if(nIndex === -1) {
                    nIndex = this.datas.length - 1;
                }
                this.load(nIndex);
            }
        },
        
        next: function() {
            if(this.datas.length > 1) {
                var nIndex = this.current + 1;
                if(nIndex === this.datas.length) {
                    nIndex = 0;
                }
                this.load(nIndex);
            }
        }
    };
    
    return box.get('util:component').create({
        extend: oProto
    });
});